/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.proxy;

import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public abstract class AbstractNetworkInstance
implements INetworkInstance {
    protected void sendMessage(byte[] bytes, @Nullable UUID target) {
    }

    protected void sendMessage(ByteBuffer byteBuffer, @Nullable UUID target) {
        this.sendMessage(AbstractNetworkInstance.safeGetBytesFromBuffer(byteBuffer), target);
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        this.sendMessage(builder.build().write(), target);
    }

    public void receiveMessage(byte[] bytes) {
        this.receiveMessage(bytes, null);
    }

    public void receiveMessage(byte[] bytes, UUID player) {
        this.receiveMessage(ByteBuffer.wrap(bytes), player);
    }

    protected void disconnect() {
        EmotesProxyManager.disconnectInstance(this);
    }

    public static byte[] safeGetBytesFromBuffer(ByteBuffer byteBuffer) {
        try {
            if (byteBuffer.isDirect() || byteBuffer.isReadOnly()) {
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                return bytes;
            }
            return byteBuffer.array();
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getRemoteVersion() {
        return 8;
    }

    @Override
    public void sendConfigCallback() {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToConfigExchange(true);
        try {
            this.sendMessage(packetBuilder, null);
        }
        catch (Exception e) {
            EmotesProxyManager.log(Level.WARNING, "Error while writing packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public int maxDataSize() {
        return Short.MAX_VALUE;
    }
}

